ORCA/M Asm65816 2.1.0

0001 87F7              *******************************************************************************
0002 87F7              * Memory.pch
0003 87F7              *
0004 87F7              * (C)  Copyright Apple Computer, Inc. 1989,1991-1992
0005 87F7              * All rights reserved.
0006 87F7              *
0007 87F7              * by Jim Mensch
0008 87F7              * 11/13/89
0009 87F7              *
0010 87F7              * This file contains patches to the memory manager for ROM 3
0011 87F7              *
0012 87F7              *
0013 87F7              * Modification History:
0014 87F7              *
0015 87F7              * Version 1.0       mensch
0016 87F7              *
0017 87F7              * 11/13/89          Mensch
0018 87F7              *                   First patch in file for disposehandle, This should fix the
0019 87F7              *                   memory hinting problem when you dispose a ungroovy handle
0020 87F7              *
0021 87F7              * 22-Jan-91         Dave Lyons
0022 87F7              *
0023 87F7              * Add new SetHandleID call (see MM:MM.asm for info and code).
0024 87F7              * Version $8302.
0025 87F7              *
0026 87F7              * 12-Jun-91         Dave Lyons
0027 87F7              *
0028 87F7              * Added check to DisposeHandle to see if we're disposing of the very first
0029 87F7              * handle.  This now returns error $0206, badHandle, instead of frying the
0030 87F7              * handle chain.
0031 87F7              *
0032 87F7              * 14-Sep-91         Dave Lyons
0033 87F7              *
0034 87F7              * Fixed a bug in CheckRecent (see MM:MM.asm for description and scenario).
0035 87F7              * Since this is in ROM on ROM 3 and is not vectorized, I have to patch
0036 87F7              * all affected calls.
0037 87F7              *
0038 87F7              *   DisposeHandle, PurgeHandle, and SetHandleSize:  Head patch, clear hints
0039 87F7              *   if they are equal.
0040 87F7              *
0041 87F7              *   DisposeAll, PurgeAll:  To keep hinting, would need to patch out the
0042 87F7              *   loops because the hints could become equal at any time during the
0043 87F7              *   calls.  Instead, I just zero out the hints as a head patch.  This
0044 87F7              *   is kind of cool anyway, because after a DisposeAll/PurgeAll, there
0045 87F7              *   are likely to be big area of free memory ready to use.
0046 87F7              *
0047 87F7              *   (By the way, ROM 1 was already zapping the hints on PurgeAll and
0048 87F7              *   DisposeAll!)
0049 87F7              *
0050 87F7              * 21-Nov-91         Dave Lyons
0051 87F7              *
0052 87F7              * DisposeHandle on first handle now returns error 0 (for compatibility).
0053 87F7              *
0054 87F7              * 19-Dec-91         Dave Lyons
0055 87F7              *
0056 87F7              * Patched SearchFail vector ($E1/16A8) to return CLC (don't try again)
0057 87F7              * when Retry gets out of range.  This fixes a problem where the retry
0058 87F7              * count would escape & count from 7 to $FFFF (takes several minutes),
0059 87F7              * and then hit 0 and crash.  (This happened only when an OOMQ routine
0060 87F7              * freed up memory on the second pass, but the handle still could not
0061 87F7              * be allocated.)
0062 87F7              *
0063 87F7              * 20-Dec-91         Dave Lyons
0064 87F7              *
0065 87F7              * Fixed the above to use MMPatcher to remove the patch on a reboot
0066 87F7              * (command-control-reset, OSShutDown).
0067 87F7              *
0068 87F7              * 31-Jan-92         Dave Lyons
0069 87F7              *
0070 87F7              * Made NewMMPatcher disable interrupts and fix the ToBramSetup vector
0071 87F7              * ($e10094).
0072 87F7              *
0073 87F7              * 5-Feb-92          Dave Lyons
0074 87F7              *
0075 87F7              * Version $0302 for 6.0 final.
0076 87F7              *
0077 87F7              *******************************************************************************
0078 87F7
0079 87F7                       title 'Memory Manager Patches' 
0080 87F7
0081 87F7              MMVersionNum equ $0302 
0082 87F7
0083 87F7                       INCLUDE ':::mm:mm.equates.asm' 
0084 87F7
0085 87F7
0086 87F7                       Title 'Call Table' 
0087 87F7              ****************************************************************
0088 87F7              *
0089 87F7              MMCallTable PROC EXPORT 
0090 87F7              *
0091 87F7              * References to all calls that are patched.
0092 87F7              *
0093 87F7              *
0094 87F7              * Inputs:
0095 87F7              *   none
0096 87F7              *
0097 87F7              * Outputs:
0098 87F7              *   none
0099 87F7              *
0100 87F7              * External Refs:
0101 87F7                       import DisposeHandle 
0102 87F7                       import MMVersion 
0103 87F7                       import SetHandleID             ;22-Jan-91 DAL
0104 87F7                       import PurgeHandle             ;14-Sep-91 DAL
0105 87F7                       import PurgeAll                ;14-Sep-91 DAL
0106 87F7                       import SetHandleSize           ;14-Sep-91 DAL
0107 87F7                       import DisposeAll              ;14-Sep-91 DAL
0108 87F7                       import MMBootInit              ;19-Dec-91 DAL
0109 87F7              *
0110 87F7              * Entry Points:
0111 87F7              *   none
0112 87F7              *
0113 87F7                       longa on                       ; mode
0114 87F7                       longi on
0115 87F7              *
0116 87F7              ****************************************************************
0117 87F7
0118 87F7
0119 87F7 31 00 00 00           DC L:(TableEnd-mmCallTable)/4  ; # entries + 1
0120 87FB
0121 87FB BA 8B 02 00           DC L:MMBootInit-1              ;01 Boot time call (patched 19-Dec-91 DAL)
0122 87FF 00 00 00 00           DC L:0                         ;02 Application init call
0123 8803 00 00 00 00           DC L:0                         ;03 App quit
0124 8807 57 8C 02 00           DC L:MMVersion-1               ;04 Version #
0125 880B 00 00 00 00           DC L:0                         ;05 Reset call
0126 880F 00 00 00 00           DC L:0                         ;               i4'MMStatus-1'         ;06 Active status
0127 8813 00 00 00 00           DC L:0                         ;               i4'NotImp-1'
0128 8817 00 00 00 00           DC L:0                         ;               i4'NotImp-1'
0129 881B
0130 881B 00 00 00 00           DC L:0                         ;               i4'NewHandle-1'        ;09 NewHandle
0131 881F 00 00 00 00           DC L:0                         ;               i4'ReallocHandle-1'    ;0A ReallocHandle
0132 8823 00 00 00 00           DC L:0                         ;               i4'RestoreHandle-1'    ;0B RestoreHandle
0133 8827 00 00 00 00           DC L:0                         ;
0134 882B 00 00 00 00           DC L:0                         ;
0135 882F 00 00 00 00           DC L:0                         ;               i4'NotImp-1'
0136 8833 00 00 00 00           DC L:0                         ;               i4'NotImp-1'
0137 8837
0138 8837 61 8C 02 00           DC L:DisposeHandle-1           ;$1002 DisposHandle
0139 883B 89 8C 02 00           DC L:DisposeAll-1              ;$1102 patched 14-Sep-91 DAL
0140 883F 90 8C 02 00           DC L:PurgeHandle-1             ;$1202 patched 14-Sep-91 DAL
0141 8843 97 8C 02 00           DC L:PurgeAll-1                ;$1302 patched 14-Sep-91 DAL
0142 8847 00 00 00 00           DC L:0                         ;               i4'NotImp-1'
0143 884B 00 00 00 00           DC L:0                         ;               i4'NotImp-1'
0144 884F 00 00 00 00           DC L:0                         ;               i4'NotImp-1'
0145 8853 00 00 00 00           DC L:0                         ;               i4'NotImp-1'
0146 8857
0147 8857 00 00 00 00           DC L:0                         ;               i4'GetHandleSize-1'    ;18 GetHandleSize
0148 885B 9E 8C 02 00           DC L:SetHandleSize-1           ;$1902 patched 14-Sep-91 DAL
0149 885F 00 00 00 00           DC L:0                         ;               i4'FindHandle-1'       ;1A FindHandle
0150 8863 00 00 00 00           DC L:0                         ;               i4'FreeMem-1'          ;1B FreeMem
0151 8867 00 00 00 00           DC L:0                         ;               i4'MaxBlock-1'         ;1C MaxBlock
0152 886B 00 00 00 00           DC L:0                         ;               i4'TotalMem-1'         ;1D TotalMem
0153 886F 00 00 00 00           DC L:0                         ;               i4'CheckHandle-1'      ;1E CheckHandle
0154 8873 00 00 00 00           DC L:0                         ;               i4'CompactMem-1'       ;1F CompactMem
0155 8877
0156 8877 00 00 00 00           DC L:0                         ;               i4'HLock-1'            ;20 HLock
0157 887B 00 00 00 00           DC L:0                         ;               i4'HLockAll-1'         ;21 HLockAll
0158 887F 00 00 00 00           DC L:0                         ;               i4'HUnlock-1'          ;22 HUnlock
0159 8883 00 00 00 00           DC L:0                         ;               i4'HUnlockAll-1'       ;23 HUnlockAll
0160 8887 00 00 00 00           DC L:0                         ;               i4'SetPurge-1'         ;24 SetPurge
0161 888B 00 00 00 00           DC L:0                         ;               i4'SetPurgeAll-1'      ;25 SetPurgeAll
0162 888F 00 00 00 00           DC L:0                         ;               i4'NotImp-1'           ;26 DeRef
0163 8893 00 00 00 00           DC L:0                         ;               i4'NotImp-1'
0164 8897
0165 8897 00 00 00 00           DC L:0                         ;               i4'PtrToHand-1'        ;28 PtrToHand
0166 889B 00 00 00 00           DC L:0                         ;               i4'HandToPtr-1'        ;29 HandToPtr
0167 889F 00 00 00 00           DC L:0                         ;               i4'HandToHand-1'       ;2A HandToHand
0168 88A3 00 00 00 00           DC L:0                         ;               i4'BlockMove-1'        ;2B BlockMove
0169 88A7 00 00 00 00           DC L:0                         ;               i4'NotImp-1'
0170 88AB 00 00 00 00           DC L:0                         ;               i4'NotImp-1'
0171 88AF 00 00 00 00           DC L:0                         ;               i4'NotImp-1'
0172 88B3 00 00 00 00           DC L:0                         ; 2F RealFreeMem
0173 88B7 D3 8C 02 00           DC L:SetHandleID-1             ; 30 SetHandleID 22-Jan-91 DAL
0174 88BB              TableEnd  
0175 88BB
0176 88BB
0177 88BB                       ENDP 
0178 88BB
0179 88BB
0180 88BB              ****************************************************************
0181 88BB              *
0182 88BB              * MMBootInit -- new patch 19-Dec-91 DAL for 6.0d62
0183 88BB              *
0184 88BB              * Patch the SearchFail vector (E1/16A8) if it isn't already
0185 88BB              * patched.
0186 88BB              *
0187 88BB              ****************************************************************
0188 88BB              MMBootInit proc export 
0189 88BB                       import mySearchFail 
0190 88BB
0191 88BB              *** rewritten 20-Dec-91 DAL for d62+, modeled after Patch2:mm.asm
0192 88BB 8B                    phb   
0193 88BC F4 E1 E1              pea   $e1e1
0194 88BF AB                    plb   
0195 88C0 AB                    plb   
0196 88C1
0197 88C1 AD A9 16              lda   |SearchFail+1
0198 88C4 C9 41 8C              cmp   #mySearchFail
0199 88C7 F0 37                 beq   DoNothing
0200 88C9
0201 88C9 08                    php   
0202 88CA 78                    sei   
0203 88CB
0204 88CB              ; Save the MMPatcher vector
0205 88CB AD 80 16              lda   |MMPatcher
0206 88CE 8F 06 8C 02           sta   >OrigMMPatcher
0207 88D2 AD 82 16              lda   |MMPatcher+2
0208 88D5 8F 08 8C 02           sta   >OrigMMPatcher+2
0209 88D9
0210 88D9              ; Set the new MMPatcher vector
0211 88D9 A9 0E 8C              lda   #NewMMPatcher
0212 88DC 8D 81 16              sta   |MMPatcher+1
0213 88DF A9 8C 02              lda   #>NewMMPatcher
0214 88E2 8D 82 16              sta   |MMPatcher+2
0215 88E5
0216 88E5              ; Save the SearchFail vector
0217 88E5 AD A8 16              lda   |SearchFail
0218 88E8 8F 0A 8C 02           sta   >OrigSearchFail
0219 88EC AD AA 16              lda   |SearchFail+2
0220 88EF 8F 0C 8C 02           sta   >OrigSearchFail+2
0221 88F3
0222 88F3              ; Set the new SearchFail vector
0223 88F3 A9 41 8C              lda   #mySearchFail
0224 88F6 8D A9 16              sta   |SearchFail+1
0225 88F9 A9 8C 02              lda   #>mySearchFail
0226 88FC 8D AA 16              sta   |SearchFail+2
0227 88FF
0228 88FF 28                    plp   
0229 8900
0230 8900 AB           DoNothing plb   
0231 8901 A9 00 00              lda   #0
0232 8904 18                    clc   
0233 8905 6B                    rtl   
0234 8906
0235 8906 00 00 00 00  OrigMMPatcher DS B:4
0236 890A 00 00 00 00  OrigSearchFail DS B:4
0237 890E
0238 890E
0239 890E 8B           NewMMPatcher phb   
0240 890F F4 E1 E1              pea   $E1E1
0241 8912 AB                    plb   
0242 8913 AB                    plb   
0243 8914
0244 8914 08                    php                            ;added 31-Jan-92 DAL
0245 8915 78                    sei                            ;added 31-Jan-92 DAL
0246 8916
0247 8916 AF 06 8C 02           lda   >OrigMMPatcher
0248 891A 8D 80 16              sta   |MMPatcher
0249 891D AF 08 8C 02           lda   >OrigMMPatcher+2
0250 8921 8D 82 16              sta   |MMPatcher+2
0251 8924
0252 8924 AF 0A 8C 02           lda   >OrigSearchFail
0253 8928 8D A8 16              sta   |SearchFail
0254 892B AF 0C 8C 02           lda   >OrigSearchFail+2
0255 892F 8D AA 16              sta   |SearchFail+2
0256 8932
0257 8932              *** added 31-Jan-92 DAL -- fix the ToBramSetup vector ($e10094)
0258 8932 A9 BB FF              lda   #$ffbb                   ;high word of jmp >$ffbb7a
0259 8935 8D 96 00              sta   |$0094+2
0260 8938 A9 5C 7A              lda   #$7a5c                   ;low word of jmp >$ffbb7a
0261 893B 8D 94 00              sta   |$0094
0262 893E
0263 893E 28                    plp   
0264 893F              *** end 31-Jan-92
0265 893F
0266 893F AB                    plb   
0267 8940 6B                    rtl   
0268 8941              *** end 20-Dec-91 DAL
0269 8941
0270 8941                       EndP 
0271 8941
0272 8941              ********************************************************************************
0273 8941              *
0274 8941              * SearchFail - Called when unable to find a segment
0275 8941              *              This routine decides what sort of compaction, etc. to do
0276 8941              *              If in an interrupt, no compaction or purging is done.
0277 8941              *
0278 8941              *  So what does it do?
0279 8941              *
0280 8941              *  First, we looke at the IRQActive flag.  If we are inside an interrupt,
0281 8941              *  we must not move or dispose of anything.  We can only fail.
0282 8941              *
0283 8941              *  If we can try and make room we look at the retry count:
0284 8941              *
0285 8941              *     1:  Let User try
0286 8941              *     2:  Compact
0287 8941              *     3:  Purge Level 3's
0288 8941              *     4:  Pugee Level 2's
0289 8941              *     5:  Purge Level 1's
0290 8941              *     6:  Let user try one last time.
0291 8941              *
0292 8941              *
0293 8941              *
0294 8941              * Output:      C = 1 if ok to retry
0295 8941              *
0296 8941              ********************************************************************************
0297 8941              *
0298 8941              * Patched 19-Dec-91 DAL.  Original code is at $FC/1188 in ROM 3.
0299 8941              *
0300 8941              ********************************************************************************
0301 8941              mySearchFail proc export 
0302 8941
0303 8941 AD CB 00              lda   |$00CB                   ;IrqActive--In an interrupt?
0304 8944 29 FF 00              and   #$00FF
0305 8947 D0 0D                 bne   myGiveUp
0306 8949
0307 8949 E6 23                 inc   Retry                    ; bump the retry count and see how many times
0308 894B A5 23                 lda   Retry                    ; we've been here
0309 894D C9 07 00              cmp   #7
0310 8950 B0 04                 bcs   myGiveUp
0311 8952
0312 8952 5C 9A 11 FC           jml   >$fc119a                 ;back to ROM 3!
0313 8956
0314 8956 18           myGiveUp clc   
0315 8957 6B                    rtl   
0316 8958
0317 8958                       EndP 
0318 8958
0319 8958
0320 8958              ****************************************************************
0321 8958              *
0322 8958              MMVersion PROC 
0323 8958              *
0324 8958              * Returns the version number of the patched memory manager.
0325 8958              *
0326 8958              *
0327 8958              * Inputs:
0328 8958              *   none
0329 8958              *
0330 8958              * Outputs:
0331 8958              *   version number
0332 8958              *
0333 8958              * External Refs:
0334 8958              *   none
0335 8958              *
0336 8958              * Entry Points:
0337 8958              *   none
0338 8958              *
0339 8958                       longa on                       ; mode
0340 8958                       longi on
0341 8958              *
0342 8958              ****************************************************************
0343 8958
0344 8958 A9 02 03              lda   #MMVersionNum
0345 895B 83 07                 sta   7,s
0346 895D A9 00 00              lda   #0                       ;No error
0347 8960 18                    clc   
0348 8961 6B                    rtl   
0349 8962
0350 8962                       ENDP 
0351 8962
0352 8962
0353 8962              ****************************************************************
0354 8962              *
0355 8962              DisposeHandle PROC 
0356 8962              *
0357 8962              * Patch the rom to make sure that handle being disposed is
0358 8962              * not the last one allocated.
0359 8962              *
0360 8962              ****************************************************************
0361 8962              RealDisposeHandle equ $FC062A 
0362 8962                       import VerifyHandle,CheckForEqualHints 
0363 8962
0364 8962 20 BA 8C              jsr   CheckForEqualHints       ;added 14-Sep-91 DAL
0365 8965
0366 8965              *** added 12-Jun-91 DAL -- disposing the very first handle is very bad!
0367 8965              ;;MemList	equ $E11600	;List of used segments
0368 8965 A3 07                 lda   7,s
0369 8967 CF 00 16 E1           cmp   >MemList
0370 896B D0 12                 bne   @notFirstHandle
0371 896D A3 09                 lda   9,s
0372 896F CF 02 16 E1           cmp   >MemList+2
0373 8973 D0 0A                 bne   @notFirstHandle
0374 8975
0375 8975              ;;;	ldx	#$0206	;bad handle error
0376 8975 A2 00 00              ldx   #0                       ;no error (21-Nov-91 DAL)
0377 8978 A0 04 00              ldy   #4
0378 897B 5C 84 01 E1           jml   $e10184                  ;ToStrip (4 bytes)
0379 897F
0380 897F              @notFirstHandle  
0381 897F              *** end of 12-Jun-91 DAL
0382 897F
0383 897F 22 88 16 E1           jsl   Link
0384 8983              ;
0385 8983              ; mensch 11/13/89
0386 8983              ; Fix BRC#53386 Disposehandle bug. Add the call to verifyHandle...
0387 8983              ;
0388 8983 20 EF 8C              jsr   VerifyHandle             ; added to insure that the passed handle is OK.
0389 8986 5C 2A 06 FC           jml   RealDisposeHandle
0390 898A
0391 898A                       ENDP 
0392 898A
0393 898A              ****************************************************************
0394 898A              *
0395 898A              * DisposeAll patched 14-Sep-91 DAL to zap the hints.  The
0396 898A              * ROM 1 code is already doing this to reduce fragmentation.
0397 898A              *
0398 898A              * Also, I have to either zap the hints here or patch out the
0399 898A              * guts of the call, because the ROM 3 CheckRecent does not
0400 898A              * realize that the low and high hints can be equal. 
0401 898A              *
0402 898A              ****************************************************************
0403 898A              DisposeAll proc 
0404 898A                       import ClearRecent 
0405 898A
0406 898A 20 A6 8C              jsr   ClearRecent
0407 898D 5C 43 06 FC           jml   >$fc0643                 ;original DisposeAll entry
0408 8991
0409 8991                       EndP 
0410 8991
0411 8991              ****************************************************************
0412 8991              *
0413 8991              * PurgeHandle patched 14-Sep-91 DAL to zap the hints if they
0414 8991              * are equal, because ROM 3 CheckRecent does not realize they
0415 8991              * can be equal, so it screws up that case (leaves high hint
0416 8991              * pointing into the void).
0417 8991              *
0418 8991              ****************************************************************
0419 8991              PurgeHandle proc 
0420 8991                       import CheckForEqualHints 
0421 8991
0422 8991 20 BA 8C              jsr   CheckForEqualHints
0423 8994 5C 80 06 FC           jml   >$fc0680                 ;original PurgeHandle entry
0424 8998
0425 8998                       endp 
0426 8998
0427 8998              ****************************************************************
0428 8998              *
0429 8998              * PurgeAll patched 14-Sep-91 DAL to zap the hints.  The
0430 8998              * ROM 1 code is already doing this to reduce fragmentation.
0431 8998              *
0432 8998              * Also, I have to either zap the hints here or patch out the
0433 8998              * guts of the call, because the ROM 3 CheckRecent does not
0434 8998              * realize that the low and high hints can be equal. 
0435 8998              *
0436 8998              ****************************************************************
0437 8998              PurgeAll proc 
0438 8998                       import ClearRecent 
0439 8998
0440 8998 20 A6 8C              jsr   ClearRecent
0441 899B 5C 8E 06 FC           jml   >$fc068e                 ;original PurgeAll entry
0442 899F
0443 899F                       endp 
0444 899F
0445 899F              ****************************************************************
0446 899F              *
0447 899F              * SetHandleSize patched 14-Sep-91 DAL to zap the hints if they
0448 899F              * are equal, because ROM 3 CheckRecent does not realize they
0449 899F              * can be equal, so it screws up that case (leaves high hint
0450 899F              * pointing into the void).
0451 899F              *
0452 899F              ****************************************************************
0453 899F              SetHandleSize proc 
0454 899F                       import CheckForEqualHints 
0455 899F
0456 899F 20 BA 8C              jsr   CheckForEqualHints
0457 89A2 5C E3 06 FC           jml   >$fc06e3                 ;original SetHandleSize entry
0458 89A6
0459 89A6                       endp 
0460 89A6
0461 89A6              ****************************************************************
0462 89A6              *
0463 89A6              * ClearRecent
0464 89A6              *
0465 89A6              * Zeros the values in LastLowHandle and LastHighHandle
0466 89A6              *
0467 89A6              ****************************************************************
0468 89A6              ClearRecent PROC 
0469 89A6
0470 89A6 A9 00 00              lda   #0
0471 89A9 8F 28 16 E1           sta   >LastLowHandle
0472 89AD 8F 2A 16 E1           sta   >LastLowHandle+2
0473 89B1 8F 2C 16 E1           sta   >LastHighHandle
0474 89B5 8F 2E 16 E1           sta   >LastHighHandle+2
0475 89B9 60                    rts   
0476 89BA
0477 89BA                       EndP 
0478 89BA
0479 89BA              ****************************************************************
0480 89BA              *
0481 89BA              * CheckForEqualHints -- 14-Sep-91 DAL
0482 89BA              *
0483 89BA              * If the high and low hints are equal, zap them.  ROM 3
0484 89BA              * CheckRecent is not prepared for them being equal.
0485 89BA              *
0486 89BA              ****************************************************************
0487 89BA              CheckForEqualHints PROC 
0488 89BA
0489 89BA 48                    pha   
0490 89BB AF 2C 16 E1           lda   >LastHighHandle
0491 89BF CF 28 16 E1           cmp   >LastLowHandle
0492 89C3 D0 0D                 bne   @exit
0493 89C5 AF 2E 16 E1           lda   >LastHighHandle+2
0494 89C9 CF 2A 16 E1           cmp   >LastLowHandle+2
0495 89CD D0 03                 bne   @exit
0496 89CF 20 A6 8C              jsr   ClearRecent
0497 89D2 68           @exit    pla   
0498 89D3 60                    rts   
0499 89D4
0500 89D4                       END   
